<?php
// Pieteikšanās pārbaude
session_start();
if ($login_successful) {
    $_SESSION['user_id'] = $user_id; // Pievienojam lietotāja ID sesijai
    $_SESSION['user'] = $username;   // Pievienojam lietotāja vārdu sesijai
}


// Datubāzes savienojuma parametri
$servername = "109.106.254.1";  
$username = "u353443769_beis";  
$password = 'Te$t@dm1n';        
$dbname = "u353443769_beis";    

// Savienojuma izveide
$conn = new mysqli($servername, $username, $password, $dbname);

// Savienojuma kļūda pārbaude
if ($conn->connect_error) {
    die("Savienojuma kļūda: " . $conn->connect_error);
}

// Pārbaudām, vai POST dati ir saņemti
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset(
    $_POST['modelis_id'], $_POST['izlaiduma_gads'], $_POST['tilpums'], $_POST['dzineja_tips_id'], $_POST['krasa_id'], 
    $_POST['nobraukums'], $_POST['virsbuves_tips_id'], $_POST['tehn_apskate'], $_POST['vin_nr'], 
    $_POST['valsts_nr_zime'], $_POST['atrumkarba_tips_id'], $_POST['cena'], $_POST['epasts'], $_POST['telefons'], 
    $_POST['apraksts']
)) {
    // Validējam un sanitizējam ievades datus
    $modelis_id = intval($_POST['modelis_id']);
    $izlaiduma_gads = intval($_POST['izlaiduma_gads']);
    $tilpums = floatval($_POST['tilpums']);
    $dzineja_tips_id = intval($_POST['dzineja_tips_id']);
    $krasa_id = intval($_POST['krasa_id']);
    $nobraukums = intval($_POST['nobraukums']);
    $virsbuves_tips_id = intval($_POST['virsbuves_tips_id']);
    $tehn_apskate = $conn->real_escape_string($_POST['tehn_apskate']);
    $vin_nr = $conn->real_escape_string($_POST['vin_nr']);
    $valsts_nr_zime = $conn->real_escape_string($_POST['valsts_nr_zime']);
    $atrumkarba_tips_id = intval($_POST['atrumkarba_tips_id']);
    $cena = floatval($_POST['cena']);
    $epasts = filter_var($_POST['epasts'], FILTER_SANITIZE_EMAIL);
    $telefons = $conn->real_escape_string($_POST['telefons']);
    $apraksts = $conn->real_escape_string($_POST['apraksts']);
    $user_id = $_SESSION['user_id']; // Lietotāja ID ņemšana no sesijas

    // Debug ziņojums, lai pārliecinātos, ka lietotāja ID ir pieejams
    echo "DEBUG: Lietotāja ID: " . $user_id;

    // SQL vaicājuma izveide
    $sql = "INSERT INTO dn_auto_masinas_info (
        modelis_id, izlaiduma_gads, tilpums, dzineja_tips_id, krasa_id, nobraukums, virsbuves_tips_id, 
        tehn_apskate, vin_nr, valsts_nr_zime, atrumkarba_tips_id, cena, epasts, telefons, apraksts, user_id
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        die("Vaicājuma sagatavošanas kļūda: " . $conn->error);
    }

    $stmt->bind_param(
        "iisiiiiisssdsis", 
        $modelis_id, 
        $izlaiduma_gads, 
        $tilpums, 
        $dzineja_tips_id, 
        $krasa_id, 
        $nobraukums, 
        $virsbuves_tips_id, 
        $tehn_apskate, 
        $vin_nr, 
        $valsts_nr_zime, 
        $atrumkarba_tips_id, 
        $cena, 
        $epasts, 
        $telefons, 
        $apraksts,
        $user_id
    );

    // Datu ievietošana un kļūdu pārbaude
    if ($stmt->execute()) {
        echo "Dati veiksmīgi pievienoti!";
    } else {
        echo "Kļūda datu pievienošanā: " . $stmt->error;
    }

    $stmt->close();
} else {
    echo "Lūdzu aizpildiet visus nepieciešamos laukus!";
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pievienot sludinājumu</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <h2>Pievienot jaunu sludinājumu</h2>
    <form action="" method="post">
        <div>
            <label>Modelis ID:</label>
            <input type="number" name="modelis_id" required>
        </div>
        <div>
            <label>Izlaiduma gads:</label>
            <input type="number" name="izlaiduma_gads" required>
        </div>
        <div>
            <label>Tilpums:</label>
            <input type="text" name="tilpums" required>
        </div>
        <div>
            <label>Dzinēja tips ID:</label>
            <input type="number" name="dzineja_tips_id" required>
        </div>
        <div>
            <label>Krāsa ID:</label>
            <input type="number" name="krasa_id" required>
        </div>
        <div>
            <label>Nobraukums:</label>
            <input type="number" name="nobraukums" required>
        </div>
        <div>
            <label>Virsbūves tips ID:</label>
            <input type="number" name="virsbuves_tips_id" required>
        </div>
        <div>
            <label>Tehniskā apskate:</label>
            <input type="date" name="tehn_apskate" required>
        </div>
        <div>
            <label>VIN Nr:</label>
            <input type="text" name="vin_nr" required>
        </div>
        <div>
            <label>Valsts Nr zīme:</label>
            <input type="text" name="valsts_nr_zime" required>
        </div>
        <div>
            <label>Ātrumkārbas tips ID:</label>
            <input type="number" name="atrumkarba_tips_id" required>
        </div>
        <div>
            <label>Cena:</label>
            <input type="text" name="cena" required>
        </div>
        <div>
            <label>E-pasts:</label>
            <input type="email" name="epasts" required>
        </div>
        <div>
            <label>Telefons:</label>
            <input type="text" name="telefons" required>
        </div>
        <div>
            <label>Apraksts:</label>
            <textarea name="apraksts" required></textarea>
        </div>
        <button type="submit">Iesniegt</button>
    </form>
</body>
</html>
